package com.xdja.spider.robot.grab;

import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.core.util.HtmlGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/8/25 下午2:01
 */
public class ScriptHandle {

    private static Logger logger = LoggerFactory.getLogger(ScriptHandle.class);

    private static String scriptPath;

    public static void init(String path) {
        scriptPath = path;
    }

    public static void handle(String sn, GrabScript script) {
        //根据content获取栏目抓取脚本 生成脚本文件  重新启动脚本
        String scriptFile = String.format("%s/grab.special.%s.py", scriptPath, sn);
        File file = new File(scriptFile);

        try {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("sn", sn);
                map.put("topic", String.format("grab.special.%s.v%s", sn, script.getVersion()));
                map.put("script", script);
                HtmlGenerator.generate("grab.special.script.ftl", map, file.getPath());
//                FileOutputStream fos = new FileOutputStream(file);
//                fos.write(script.getScript().getBytes());
//                fos.flush();
//                fos.close();

            logger.debug("重启特殊抓取脚本");
            Runtime.getRuntime().exec(scriptPath + "/grab.sh restart " + scriptPath + " grab.special." + sn);
        } catch (IOException e) {
            logger.error("启动特殊抓取失败", e);
        }
    }


    public static void main(String[] args) {
        try {
            File file = new File("/Users/hsun/Documents/projects/git/spider/doc/script/test.py");
            if (!file.exists()) {
                file.getParentFile().mkdir();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write("print 1".getBytes());
            fos.flush();
            fos.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
