package com.xdja.spider.robot.init;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.HtmlGenerator;
import com.xdja.spider.robot.grab.GrabAction;
import com.xdja.spider.robot.grab.ScriptHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Properties;

/**
 * 应用初始化
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/26 下午5:32
 */
@Service
public class RobotInit implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(RobotInit.class);

    @Autowired
    private GrabAction grabAction;

    @Override
    public void afterPropertiesSet() throws Exception {
        Properties properties = PropertiesLoaderUtils.loadAllProperties("system.properties");
        String url = properties.getProperty("rmq.url");
        String username = properties.getProperty("rmq.username");
        String password = properties.getProperty("rmq.password");
        String queueName = properties.getProperty("rmq.queue.name");
        String threadSize = properties.getProperty("rmq.thread.size");

        logger.debug("##########################");
        logger.debug("初始化RMQ:{}",url);

        MQSetting.init(username, password, url, queueName);
        MQSetting.setCodec(Rmq.CODEC);
        MQSetting.setThreadSize(Integer.parseInt(threadSize));

        MQSetting.initChanel(Arrays.asList(Rmq.TOPIC_GRAB_GENERAL, Rmq.TOPIC_GRAB_SPECIAL_START, Rmq.TOPIC_GRAB_SPECIAL_HANDLE));
        MQSetting.registAction(grabAction, true);

        String fastdfsHost = properties.getProperty("fastdfs.host");
        String fastdfsUserId = properties.getProperty("fastdfs.user.id");
        String fastdfsUserSecret = properties.getProperty("fastdfs.user.secret");
        logger.debug("##########################");
        logger.debug("初始化FastDFS:{}",fastdfsHost);
        FastDFSUtil.init(fastdfsHost, fastdfsUserId, fastdfsUserSecret);


        String staticPath = properties.getProperty("static.path");
        logger.debug("##########################");
        logger.debug("静态化文件保存路径:{}",staticPath);
        HtmlGenerator.init(staticPath);

        String scriptPath = properties.getProperty("script.path");
        logger.debug("##########################");
        logger.debug("特殊脚本文件路径:{}",scriptPath);
        ScriptHandle.init(scriptPath);

    }
}
