package com.xdja.uaac.api;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

/**
 * Author:kongguoguang
 * Date:2018-03-07
 * Time:10:09
 * Summary:
 */

public class UaacApi {

    private static final String UAAC_ACTION = "com.xdja.uaac.action.TOKEN_CREDENTIAL";

    public static void getCredential(@NonNull Context context,
                                     String messageId,
                                     String version,
                                     String appId,
                                     String orgId,
                                     String networkAreaCode,
                                     String packageName,
                                     @NonNull CredentialCallback callback){

        if (TextUtils.isEmpty(packageName)){
            packageName = context.getPackageName();
        }

        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_METHOD, ParamKeywords.KEY_METHOD_CREDENTIAL);
        bundle.putString(ParamKeywords.KEY_MESSAGE_ID, messageId);
        bundle.putString(ParamKeywords.KEY_VERSION, version);
        bundle.putString(ParamKeywords.KEY_APP_ID, appId);
        bundle.putString(ParamKeywords.KEY_ORG_ID, orgId);
        bundle.putString(ParamKeywords.KEY_NETWORK_AREA_CODE, networkAreaCode);
        bundle.putString(ParamKeywords.KEY_PACKAGE_NAME, packageName);
        bundle.putBinder(ParamKeywords.KEY_BINDER, new UaacApiCallback(callback).asBinder());

        Intent intent = new Intent(UAAC_ACTION);
        intent.putExtra(ParamKeywords.KEY_BUNDLE, bundle);
        if (!(context instanceof Activity)){
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }

        try {
            context.startActivity(intent);
        } catch (Exception e){
            Bundle resultBundle = new Bundle();
            resultBundle.putInt(ParamKeywords.KEY_RESULT_CODE, UaacErrorCode.UAAC_NOT_EXIST);
            callback.onResult(resultBundle);
        }

    }

    public static void getToken(@NonNull Context context, @NonNull TokenCallback callback){
        getToken(context, "", callback);
    }

    /**
     * 获取票据
     *
     * @param context     Context
     * @param packageName packageName
     * @param callback    TokenCallback
     */
    public static void getToken(@NonNull Context context, String packageName, @NonNull TokenCallback callback) {

        if (TextUtils.isEmpty(packageName)){
            packageName = context.getPackageName();
        }

        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_METHOD, ParamKeywords.KEY_METHOD_TOKEN);
        bundle.putString(ParamKeywords.KEY_PACKAGE_NAME, packageName);
        bundle.putBinder(ParamKeywords.KEY_BINDER, new UaacApiCallback(callback).asBinder());
        Intent intent = new Intent(UAAC_ACTION);
        intent.putExtra(ParamKeywords.KEY_BUNDLE, bundle);
        if (!(context instanceof Activity)){
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }

        try {
            context.startActivity(intent);
        } catch (Exception e){
            Bundle resultBundle = new Bundle();
            resultBundle.putInt(ParamKeywords.KEY_RESULT_CODE, UaacErrorCode.UAAC_NOT_EXIST);
            callback.onResult(resultBundle);
        }

    }

    /**
     *
     * @param context
     * @return 0：注销成功；-1：无权调用注销接口
     */
    public static int logoutUaac(@NonNull Context context){
        Uri uri = Uri.parse("content://com.xdja.app.pj/" + context.getPackageName());
        ContentResolver contentResolver = context.getContentResolver();
        int result = 0;
        try {
            result = contentResolver.delete(uri, null, null);
        }catch (Exception e){
            return result;
        }

        return result;
    }

    /**
     * 应用退出时通知统一认证
     * @param context
     */
    public static void notifyLogout(@NonNull Context context){
        Intent intent = new Intent("com.xdja.unifyauthorize.ACTION_THIRD_APP_LOGOUT");
        intent.putExtra("PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(intent);
    }
}
