package com.xdja.uaac.api;

import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;

/**
 * Date:2019/10/29
 * Time:19:14
 * Summary:
 * @author kgg
 */
public class UaacApiCallback extends IUaacApiCallback.Stub{

    private TokenCallback tokenCallback;

    private CredentialCallback credentialCallback;

    public UaacApiCallback(TokenCallback tokenCallback) {
        this.tokenCallback = tokenCallback;
    }

    public UaacApiCallback(CredentialCallback credentialCallback) {
        this.credentialCallback = credentialCallback;
    }

    /**
     * 该方法在子线程中执行，故采用Handler处理
     * @param bundle
     * @throws RemoteException
     */
    @Override
    public void callback(Bundle bundle) throws RemoteException {
        Message message = Message.obtain();
        message.obj = bundle;
        handler.sendMessage(message);
    }

    private void callbackToken(Bundle bundle){
        tokenCallback.onResult(bundle);
    }

    private void callbackCredential(Bundle bundle){
        credentialCallback.onResult(bundle);
    }

    private Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Bundle bundle = (Bundle) msg.obj;

            if (tokenCallback != null){
                callbackToken(bundle);
                return;
            }

            if (credentialCallback != null){
                callbackCredential(bundle);
            }
        }
    };
}
